unit AboutForm;
{*******************************************************************************
  ProcessChecker Demo
  Written by David Clegg, davidclegg@optusnet.com.au.

  Form showing a brief description about the ProcessChecker application.
*******************************************************************************}

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources;

type
  TAboutForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    pbLogo: System.Windows.Forms.PictureBox;
    label3: System.Windows.Forms.Label;
    label2: System.Windows.Forms.Label;
    lblDescription: System.Windows.Forms.Label;
    lblBuild: System.Windows.Forms.Label;
    lblRelease: System.Windows.Forms.Label;
    lblVersion: System.Windows.Forms.Label;
    lblAppName: System.Windows.Forms.Label;
    btnClose: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TAboutForm_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    procedure PopulateControls;
  public
    constructor Create;
    class function ShowAboutForm: System.Windows.Forms.DialogResult;
  end;

implementation

uses
  System.Globalization, System.Diagnostics, SysUtils;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TAboutForm.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TAboutForm));
  Self.pbLogo := System.Windows.Forms.PictureBox.Create;
  Self.label3 := System.Windows.Forms.Label.Create;
  Self.label2 := System.Windows.Forms.Label.Create;
  Self.lblDescription := System.Windows.Forms.Label.Create;
  Self.lblBuild := System.Windows.Forms.Label.Create;
  Self.lblRelease := System.Windows.Forms.Label.Create;
  Self.lblVersion := System.Windows.Forms.Label.Create;
  Self.lblAppName := System.Windows.Forms.Label.Create;
  Self.btnClose := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // pbLogo
  // 
  Self.pbLogo.Image := (System.Drawing.Image(resources.GetObject('pbLogo.Image')));
  Self.pbLogo.Location := System.Drawing.Point.Create(17, 11);
  Self.pbLogo.Name := 'pbLogo';
  Self.pbLogo.Size := System.Drawing.Size.Create(72, 72);
  Self.pbLogo.SizeMode := System.Windows.Forms.PictureBoxSizeMode.StretchImage;
  Self.pbLogo.TabIndex := 21;
  Self.pbLogo.TabStop := False;
  // 
  // label3
  // 
  Self.label3.Location := System.Drawing.Point.Create(9, 243);
  Self.label3.Name := 'label3';
  Self.label3.Size := System.Drawing.Size.Create(160, 16);
  Self.label3.TabIndex := 20;
  Self.label3.Text := 'davidclegg@optusnet.com.au';
  // 
  // label2
  // 
  Self.label2.Location := System.Drawing.Point.Create(9, 227);
  Self.label2.Name := 'label2';
  Self.label2.Size := System.Drawing.Size.Create(144, 16);
  Self.label2.TabIndex := 19;
  Self.label2.Text := 'Written by David Clegg';
  // 
  // lblDescription
  // 
  Self.lblDescription.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8.25, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblDescription.Location := System.Drawing.Point.Create(17, 99);
  Self.lblDescription.Name := 'lblDescription';
  Self.lblDescription.Size := System.Drawing.Size.Create(264, 104);
  Self.lblDescription.TabIndex := 18;
  Self.lblDescription.Text := 'lblDescription';
  // 
  // lblBuild
  // 
  Self.lblBuild.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8.25, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblBuild.Location := System.Drawing.Point.Create(129, 65);
  Self.lblBuild.Name := 'lblBuild';
  Self.lblBuild.Size := System.Drawing.Size.Create(104, 16);
  Self.lblBuild.TabIndex := 17;
  Self.lblBuild.Text := 'lblBuild';
  // 
  // lblRelease
  // 
  Self.lblRelease.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 9.75, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblRelease.Location := System.Drawing.Point.Create(129, 47);
  Self.lblRelease.Name := 'lblRelease';
  Self.lblRelease.Size := System.Drawing.Size.Create(104, 14);
  Self.lblRelease.TabIndex := 16;
  Self.lblRelease.Text := 'lblRelease';
  // 
  // lblVersion
  // 
  Self.lblVersion.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 9.75, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblVersion.Location := System.Drawing.Point.Create(129, 29);
  Self.lblVersion.Name := 'lblVersion';
  Self.lblVersion.Size := System.Drawing.Size.Create(104, 14);
  Self.lblVersion.TabIndex := 15;
  Self.lblVersion.Text := 'lblVersion';
  // 
  // lblAppName
  // 
  Self.lblAppName.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 9.75, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.lblAppName.Location := System.Drawing.Point.Create(129, 11);
  Self.lblAppName.Name := 'lblAppName';
  Self.lblAppName.Size := System.Drawing.Size.Create(120, 14);
  Self.lblAppName.TabIndex := 14;
  Self.lblAppName.Text := 'lblAppName';
  // 
  // btnClose
  // 
  Self.btnClose.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.btnClose.Location := System.Drawing.Point.Create(209, 235);
  Self.btnClose.Name := 'btnClose';
  Self.btnClose.TabIndex := 13;
  Self.btnClose.Text := 'Close';
  // 
  // TAboutForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 270);
  Self.Controls.Add(Self.pbLogo);
  Self.Controls.Add(Self.label3);
  Self.Controls.Add(Self.label2);
  Self.Controls.Add(Self.lblDescription);
  Self.Controls.Add(Self.lblBuild);
  Self.Controls.Add(Self.lblRelease);
  Self.Controls.Add(Self.lblVersion);
  Self.Controls.Add(Self.lblAppName);
  Self.Controls.Add(Self.btnClose);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TAboutForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'About Process Checker...';
  Self.TransparencyKey := System.Drawing.Color.Fuchsia;
  Include(Self.Load, Self.TAboutForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TAboutForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TAboutForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TAboutForm.TAboutForm_Load(sender: System.Object; e: System.EventArgs);
begin
  PopulateControls;
end;

procedure TAboutForm.PopulateControls;
var
  lVersionInfo: FileVersionInfo;
begin
  lVersionInfo := FileVersionInfo.GetVersionInfo(Application.ExecutablePath);
  lblAppName.Text := lVersionInfo.FileDescription;
  lblVersion.Text := Format('Version %s.%s',
    [lVersionInfo.ProductMajorPart, lVersionInfo.ProductMinorPart]);
  lblRelease.Text := Format('Release %s', [lVersionInfo.ProductBuildPart]);
  lblBuild.Text := Format('Build %s', [lVersionInfo.ProductPrivatePart]);
  lblDescription.Text := lVersionInfo.Comments;
  Bitmap(pbLogo.Image).MakeTransparent;
end;

class function TAboutForm.ShowAboutForm: System.Windows.Forms.DialogResult;
begin
  with TAboutForm.Create do
    Result := ShowDialog;
end;

end.
